// 1. 準備OKフラグ送信 --> main.js
// 2. 横幅受信 <-- main.js (1.の返信)
// 3. 横幅受信後、画像読込
// 4. 画像読込後、サイズ送信 --> main.js

//window.addEventListener('DOMContentLoaded', () => {
window.addEventListener('load', () => {

  const path = require('path')
  const { ipcRenderer } = require('electron')
  // const { contextBridge } = require("electron");
  // contextBridge.exposeInMainWorld("electron", {
  //   ipcRenderer: ipcRenderer
  // });

  var _ghost = document.getElementById("ghost");
  var width = false;
  var GHOST_CONF = false;

  // 画像の読込が終了したら、サイズの情報を main.js に送る
  // アセットの変更時にも送る
  _ghost.addEventListener("load", (e) => {
    var __ghost = window.getComputedStyle(_ghost);
    ipcRenderer.send('ghost-size-message', JSON.stringify({
      width: ~~(__ghost.width.split("px")[0]),
      height: ~~(__ghost.height.split("px")[0])
    }));
  });

  // 準備OKフラグ送信
  ipcRenderer.send('ghost-ready-message', "1");
  // 横幅受信 (準備OKフラグの返信として受信)
  ipcRenderer.on('ghost-ready-reply', (e, arg) => {
    var a = JSON.parse(arg);
    GHOST_CONF = require(path.join(__dirname, "..", "ghost", a.ghost, "config.js"));
    // 画像読込
    _ghost.style.width = a.width + "px";
    _ghost.src = GHOST_CONF.ghost.asset.default;
  });

  // トーク時のアセット受信
  ipcRenderer.on('ghost-aseet-message', (e, arg) => {
    // 画像読込
    _ghost.src = GHOST_CONF.ghost.asset[arg];
  });

  document.getElementById("ghost_clickarea").addEventListener("dblclick", () => {
    ipcRenderer.send('input-open-message', "1");
  });

  ipcRenderer.on('menu-ok-message', (e, arg) => {
    document.getElementById("ghost_clickarea").addEventListener("contextmenu", () => {
      ipcRenderer.send('menu-open-message', "1");
    });
  });


})

