//window.addEventListener('DOMContentLoaded', () => {
window.addEventListener('load', () => {

  const path = require('path');
  const { ipcRenderer } = require('electron');
  // const { contextBridge } = require('electron');
  // contextBridge.exposeInMainWorld("electron", {
  //   ipcRenderer: ipcRenderer
  // });

  //var GHOST_CONF = false;
  var INIT_CONF = require(path.join(__dirname, "..", "config.js"));

  var userconf_width = document.getElementById("userconf_width");
  var userconf_interval = document.getElementById("userconf_interval");
  var userconf_ghost = document.getElementById("userconf_ghost");
  var userconf_name = document.getElementById("userconf_name");
  var userconf_teiji = document.getElementById("userconf_teiji");
  var userconf_name_button = document.getElementById("userconf_name_button");
  userconf_width.innerHTML = "";
  for (let i=0; i < 20; i++) {
    userconf_width.insertAdjacentHTML(
      'beforeend',
      '<option value="'+(100 + i*10)+'">'+(100 + i*10)+'</option>'
    );
  }
  userconf_interval.innerHTML = "";
  for (let i=0; i < 20; i++) {
    userconf_interval.insertAdjacentHTML(
      'beforeend',
      '<option value="'+(1000 + i*200)+'">'+(1000 + i*200)+'</option>'
    );
  }
  userconf_teiji.innerHTML = '<option value=""></option>';
  for (let h=0; h < 24; h++) {
    for (let m=0; m < 6; m++) {
      let t = ("00" + h).slice(-2) + ":" + ("00" + m*10).slice(-2);
      userconf_teiji.insertAdjacentHTML(
        'beforeend',
        '<option value="'+t+'">'+t+'</option>'
      );
    }
  }
  userconf_ghost.innerHTML = "";
  for (let i=0; i < INIT_CONF.ghostlist.length; i++) {
    userconf_ghost.insertAdjacentHTML(
      'beforeend',
      '<option value="'+ INIT_CONF.ghostlist[i] +'">'+INIT_CONF.ghostlist[i]+'</option>'
    );
  }

  // 終了ボタンが押されたら送信
  document.getElementById("quit_button").addEventListener('click', function(event) {
    ipcRenderer.send('app-quit-message', "1");
  });

  // 「Munohウェブサイトへ」ボタンが押されたら送信
  document.getElementById("munohweb_button").addEventListener('click', function(event) {
    ipcRenderer.send('web-access-message', "http://alice.helixcode.net/~bando/pub/Munoh/");
  });
  // 「近大高専を知る」ボタンが押されたら送信
  document.getElementById("kutcs_button").addEventListener('click', function(event) {
    ipcRenderer.send('web-access-message', "https://www.ktc.ac.jp/s/");
  });
  // 「近大高専 情報コースの最新情報」ボタンが押されたら送信
  document.getElementById("kutci_button").addEventListener('click', function(event) {
    ipcRenderer.send('web-access-message', 'https://www.ktc.ac.jp/cms/?s=&cat=7&orderby=date&order=DESC');
  });

  // 準備OKフラグ送信
  ipcRenderer.send('menu-ready-message', "1");
  // ゴーストの種類受信 (準備OKフラグの返信として受信)
  ipcRenderer.on('menu-ready-reply', (e, arg) => {
    var a = JSON.parse(arg);
    // size
    userconf_width.value = +a.width;
    userconf_width.addEventListener("change", (e) => {
      ipcRenderer.send("userconf-width-change-message", e.target.value);
    });
    // interval
    userconf_interval.value = +a.interval;
    userconf_interval.addEventListener("change", (e) => {
      ipcRenderer.send("userconf-interval-change-message", e.target.value);
    });
    // ghost
    userconf_ghost.value = a.ghost;
    userconf_ghost.addEventListener("change", (e) => {
      ipcRenderer.send("userconf-ghost-change-message", e.target.value);
    });
    // teiji
    userconf_teiji.value = a.teiji;
    userconf_teiji.addEventListener("change", (e) => {
      ipcRenderer.send("userconf-teiji-change-message", e.target.value);
    });
    if (a.name) {
      userconf_name.value = a.name;
    } else {
      userconf_name.value = "";
    }
    userconf_name_button.addEventListener("click", (e) => {
      ipcRenderer.send("userconf-name-change-message", userconf_name.value);
    });
    ipcRenderer.send('menu-openready-message', "1");
    //GHOST_CONF = require(path.join(__dirname, "..", "ghost", a.ghost, "config.js"));
  });

})
