// All of the Node.js APIs are available in the preload process.
// It has the same sandbox as a Chrome extension.
window.addEventListener('DOMContentLoaded', () => {

  const { contextBridge } = require("electron");

  var _ghost = document.getElementById("ghost");
  var __ghost = window.getComputedStyle(_ghost);

  // ghostのサイズを main.js に送信
  const { ipcRenderer } = require('electron')
  ipcRenderer.on('ghostsize-reply', (event, arg) => {
    //console.log(arg)
  })
  var gint = setInterval(function() {
    if (__ghost.width.split("px")[0] != 0) {
      ipcRenderer.send('ghostsize-message', JSON.stringify({
        width: ~~(__ghost.width.split("px")[0]),
        height: ~~(__ghost.height.split("px")[0])
      }));
      clearInterval(gint);
    }
  }, 500);

  contextBridge.exposeInMainWorld("electron", {
    ipcRenderer: ipcRenderer
  });

  // アセット受け取り
  ipcRenderer.on('_ghostasset-message', (event, arg) => {
    document.getElementById("ghost").src = CONF.ghost.asset[arg];
  })

  // CONF 受け取り
  var CONF;
  ipcRenderer.on('_ghostconf-message', (event, arg) => {
    //console.log(arg)
    CONF = JSON.parse(arg);
  })

})
